import { createAsyncThunk, createSlice } from '@reduxjs/toolkit';
import { queryResponse } from '../../util/processResponse.js';

const initialState = {
    vendor: {},
    loading: false,
};

export const getItemsOwner = createAsyncThunk(
    'item/itemsOwner',
    async (URL) => {
        const res = await queryResponse(URL);
        return res;
    }
);

const itemOwnerSlice = createSlice({
    name: 'itemOwner',
    initialState,
    reducers: {
        resetVendorInfo: (state) => {
            state.vendor = {};
            state.loading = false;
        },
    },
    extraReducers: (builder) => {
        builder.addCase(getItemsOwner.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getItemsOwner.fulfilled, (state, { payload }) => {
            const { records, status } = payload;
            if (status?.code == 200) {
                state.vendor = records?.data;
            }
            state.loading = false;
        });
        builder.addCase(getItemsOwner.rejected, (state) => {
            state.loading = false;
        });
    },
});

export const { resetVendorInfo } = itemOwnerSlice.actions;
export default itemOwnerSlice.reducer;
